(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20072,        466]*)
(*NotebookOutlinePosition[     22856,        554]*)
(*  CellTagsIndexPosition[     22785,        548]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ 
      Check\ the\ Non - 
        ResonanceCondition\ from\ Takens\ Paper\ for\ Periodic\ Cycles\ \
\((constant\ or\ 2 - periodic\ CF - 
              Development)\)\ in\ Bianchi\ IX\ *) \)\(\[IndentingNewLine]\)\( \
(*\ Do\ everything\ in\ a\ For - Loop\ for\ m, \ 
      thus\ testing\ everything\ at\ once\ and\ printing\ the\ output\ \
*) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\ 
      Parameters\ *) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(\(k\  \
= \ 1;\)\(\ \ \)\( (*\ 
      desired\ smoothness\ of\ coordinate\ change\ from\ takens\ theorem\ \
*) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\ 
      for\ u = \(\([m, a, a, \(\(...\)\(.\)\)]\)\ we\ do\ a\ for - 
            loop\ to\ test\ it\ for\ a = \(1.  .. \) 
            aMAX\)\ *) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)
    \(aMAX\  = \ 5;\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\ 
      for\ u = \([m, a, 
            b,  ... ]\)\ we\ use\ the\ following\ parameters\ *) \)\(\
\[IndentingNewLine]\)\(\[IndentingNewLine]\)
    \(a\  = \ 2;\)\(\[IndentingNewLine]\)
    \(b = \ 4;\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)
    \(aBackup\  = \ a; \  (*\ 
      Restore\ a\ to\ the\ inital\ value\ after\ the\ for - 
        loop\ *) \[IndentingNewLine]\[IndentingNewLine]For[a = 1, 
      a < aMAX + 
          1, \(a++\), \[IndentingNewLine]\[IndentingNewLine]Print["\<For \
u=[m,a,a,...] and m=1...a, AND a=\>", 
          a]\[IndentingNewLine]\[IndentingNewLine]For[m = 1, 
          m < a + 1, \(m++\), \[IndentingNewLine]\[IndentingNewLine]u = \ 
            FromContinuedFraction[{m, {a}}]; \[IndentingNewLine]\
\[IndentingNewLine]l1\  = \ \((\(-6\) u)\)/\((1 + u + 
                  u^2)\); \[IndentingNewLine]l2\  = \ \((6 + 6  u)\)/\((1 + 
                  u + u^2)\); \[IndentingNewLine]l3\  = \ \((6  u + 
                  6  u^2)\)/\((1 + u + 
                  u^2)\); \[IndentingNewLine]\[IndentingNewLine]EVlist\  = \ \
{\(-N[l1]\), \(-N[l2]\), \(-N[l3]\)}; \  (*\ 
            IMPORTANT : \ Reverse\ the\ signs\ of\ the\ Eigenvalues, \ 
            because\ we\ go\ to\ Big\ Bang, \ 
            i . e . \ 
                t\ goes\ to\ MINUS\ Infinity\ \
*) \[IndentingNewLine]PositiveEV\  = \ 
            Select[EVlist, # > 0\  &]; \[IndentingNewLine]NegativeEV\  = \ 
            Select[EVlist, # < 
                  0\  &]; \[IndentingNewLine]\[IndentingNewLine]N9 = \ \(-Min[
                NegativeEV]\); \[IndentingNewLine]n9 = \ \(-Max[
                NegativeEV]\); \[IndentingNewLine]m9 = \ 
            Min[PositiveEV]; \[IndentingNewLine]M9 = \ 
            Max[PositiveEV]; \[IndentingNewLine]\[IndentingNewLine]beta9 = \ 
            Ceiling[\((N9 + k \((M9 + n9)\))\)/
                n9]; \[IndentingNewLine]alpha9\  = \ 
            Ceiling[\((M9 + beta9 \((N9 + m9)\))\)/
                m9]; \[IndentingNewLine]\[IndentingNewLine]Print["\<m=\>", 
            m, "\< alpha= \>", alpha9, "\< beta=\>", 
            beta9, "\<  k1=\>", \(-m^2\) + a*m - 2  m + 
              a, "\<  k2=\>", \(-m^2\) + a*m + 
              1, "\<  k3=\>", \(-1\)];\[IndentingNewLine]\[IndentingNewLine]]\
\[IndentingNewLine]\[IndentingNewLine]]\)\(\[IndentingNewLine]\)\(\
\[IndentingNewLine]\)
    \(a\  = \ aBackup; \ \  (*\ 
      Restore\ a\ to\ the\ inital\ value\ after\ the\ for - 
        loop\ *) \[IndentingNewLine]\[IndentingNewLine]Print["\<Now use \
a=\>", a, "\< and b=\>", b]\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)
    \(Print["\<For u=[m,a,b,a,b,...] and m=1...b\>"]\)\(\[IndentingNewLine]\)\
\(\[IndentingNewLine]\)
    \(For[m = 1, 
      m < b + 1, \(m++\), \[IndentingNewLine]\[IndentingNewLine]u = \ 
        FromContinuedFraction[{m, {a, 
              b}}]; \[IndentingNewLine]\[IndentingNewLine]l1\  = \ \((\(-6\) 
              u)\)/\((1 + u + u^2)\); \[IndentingNewLine]l2\  = \ \((6 + 
              6  u)\)/\((1 + u + 
              u^2)\); \[IndentingNewLine]l3\  = \ \((6  u + 6  u^2)\)/\((1 + 
              u + u^2)\); \[IndentingNewLine]\[IndentingNewLine]EVlist\  = \ \
{\(-N[l1]\), \(-N[l2]\), \(-N[l3]\)}; \  (*\ 
        IMPORTANT : \ Reverse\ the\ signs\ of\ the\ Eigenvalues, \ 
        because\ we\ go\ to\ Big\ Bang, \ 
        i . e . \ 
            t\ goes\ to\ MINUS\ Infinity\ *) \[IndentingNewLine]PositiveEV\  \
= \ Select[EVlist, # > 0\  &]; \[IndentingNewLine]NegativeEV\  = \ 
        Select[
          EVlist, # < 
              0\  &]; \[IndentingNewLine]\[IndentingNewLine]N9 = \ \(-Min[
            NegativeEV]\); \[IndentingNewLine]n9 = \ \(-Max[
            NegativeEV]\); \[IndentingNewLine]m9 = \ 
        Min[PositiveEV]; \[IndentingNewLine]M9 = \ 
        Max[PositiveEV]; \[IndentingNewLine]\[IndentingNewLine]beta9 = \ 
        Ceiling[\((N9 + k \((M9 + n9)\))\)/
            n9]; \[IndentingNewLine]alpha9\  = \ 
        Ceiling[\((M9 + beta9 \((N9 + m9)\))\)/
            m9]; \[IndentingNewLine]\[IndentingNewLine]Print["\<m=\>", 
        m, "\< alpha= \>", alpha9, "\< beta=\>", beta9, "\<  k1=\>", 
        b + a*b*m - a*m^2\  - 2  a*m + a*b\  - a, "\<  k2=\>", 
        b + a*b*m - 
          a*m^2\ , "\<  k3=\>", \
\(-a\)];\[IndentingNewLine]\[IndentingNewLine]]\)\(\ \
\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)
    \(Print["\<For u=[m,b,a,b,a,...] and m=1...a\>"]\)\(\[IndentingNewLine]\)\
\(\[IndentingNewLine]\)
    \(For[m = 1, 
      m < a + 1, \(m++\), \[IndentingNewLine]\[IndentingNewLine]u = \ 
        FromContinuedFraction[{m, {b, 
              a}}]; \[IndentingNewLine]\[IndentingNewLine]l1\  = \ \((\(-6\) 
              u)\)/\((1 + u + u^2)\); \[IndentingNewLine]l2\  = \ \((6 + 
              6  u)\)/\((1 + u + 
              u^2)\); \[IndentingNewLine]l3\  = \ \((6  u + 6  u^2)\)/\((1 + 
              u + u^2)\); \[IndentingNewLine]\[IndentingNewLine]EVlist\  = \ \
{\(-N[l1]\), \(-N[l2]\), \(-N[l3]\)}; \  (*\ 
        IMPORTANT : \ Reverse\ the\ signs\ of\ the\ Eigenvalues, \ 
        because\ we\ go\ to\ Big\ Bang, \ 
        i . e . \ 
            t\ goes\ to\ MINUS\ Infinity\ *) \[IndentingNewLine]PositiveEV\  \
= \ Select[EVlist, # > 0\  &]; \[IndentingNewLine]NegativeEV\  = \ 
        Select[EVlist, # < 
              0\  &]; \[IndentingNewLine]\[IndentingNewLine]N9 = \ \(-Min[
            NegativeEV]\); \[IndentingNewLine]n9 = \ \(-Max[
            NegativeEV]\); \[IndentingNewLine]m9 = \ 
        Min[PositiveEV]; \[IndentingNewLine]M9 = \ 
        Max[PositiveEV]; \[IndentingNewLine]\[IndentingNewLine]beta9 = \ 
        Ceiling[\((N9 + k \((M9 + n9)\))\)/
            n9]; \[IndentingNewLine]alpha9\  = \ 
        Ceiling[\((M9 + beta9 \((N9 + m9)\))\)/
            m9]; \[IndentingNewLine]\[IndentingNewLine]Print["\<m=\>", 
        m, "\< alpha= \>", alpha9, "\< beta=\>", beta9, "\<  k1=\>", 
        a + a*b*m - b*m^2 - 2  b*m + a*b - b, "\<  k2=\>", 
        a + a*b*m - 
          b*m^2, "\<  k3=\>", \(-b\)];\ \
\[IndentingNewLine]\[IndentingNewLine]]\)\(\ \)\)\)\)], "Input",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("For u=[m,a,a,...] and m=1...a, AND a="\
\[InvisibleSpace]1\),
      SequenceForm[ "For u=[m,a,a,...] and m=1...a, AND a=", 1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]16\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]\(-1\)\[InvisibleSpace]"  k2="\
\[InvisibleSpace]1\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 16, " beta=", 4, "  k1=", -1, "  k2=", 1, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("For u=[m,a,a,...] and m=1...a, AND a="\
\[InvisibleSpace]2\),
      SequenceForm[ "For u=[m,a,a,...] and m=1...a, AND a=", 2],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]12\[InvisibleSpace]" beta="\[InvisibleSpace]3\
\[InvisibleSpace]"  k1="\[InvisibleSpace]1\[InvisibleSpace]"  k2="\
\[InvisibleSpace]2\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 12, " beta=", 3, "  k1=", 1, "  k2=", 2, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]2\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]24\[InvisibleSpace]" beta="\[InvisibleSpace]5\
\[InvisibleSpace]"  k1="\[InvisibleSpace]\(-2\)\[InvisibleSpace]"  k2="\
\[InvisibleSpace]1\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 2, " alpha= ", 24, " beta=", 5, "  k1=", -2, "  k2=", 1, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("For u=[m,a,a,...] and m=1...a, AND a="\
\[InvisibleSpace]3\),
      SequenceForm[ "For u=[m,a,a,...] and m=1...a, AND a=", 3],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]11\[InvisibleSpace]" beta="\[InvisibleSpace]3\
\[InvisibleSpace]"  k1="\[InvisibleSpace]3\[InvisibleSpace]"  k2="\
\[InvisibleSpace]3\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 11, " beta=", 3, "  k1=", 3, "  k2=", 3, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]2\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]19\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]1\[InvisibleSpace]"  k2="\
\[InvisibleSpace]3\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 2, " alpha= ", 19, " beta=", 4, "  k1=", 1, "  k2=", 3, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]3\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]33\[InvisibleSpace]" beta="\[InvisibleSpace]6\
\[InvisibleSpace]"  k1="\[InvisibleSpace]\(-3\)\[InvisibleSpace]"  k2="\
\[InvisibleSpace]1\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 3, " alpha= ", 33, " beta=", 6, "  k1=", -3, "  k2=", 1, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("For u=[m,a,a,...] and m=1...a, AND a="\
\[InvisibleSpace]4\),
      SequenceForm[ "For u=[m,a,a,...] and m=1...a, AND a=", 4],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]11\[InvisibleSpace]" beta="\[InvisibleSpace]3\
\[InvisibleSpace]"  k1="\[InvisibleSpace]5\[InvisibleSpace]"  k2="\
\[InvisibleSpace]4\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 11, " beta=", 3, "  k1=", 5, "  k2=", 4, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]2\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]18\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]4\[InvisibleSpace]"  k2="\
\[InvisibleSpace]5\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 2, " alpha= ", 18, " beta=", 4, "  k1=", 4, "  k2=", 5, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]3\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]28\[InvisibleSpace]" beta="\[InvisibleSpace]5\
\[InvisibleSpace]"  k1="\[InvisibleSpace]1\[InvisibleSpace]"  k2="\
\[InvisibleSpace]4\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 3, " alpha= ", 28, " beta=", 5, "  k1=", 1, "  k2=", 4, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]4\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]45\[InvisibleSpace]" beta="\[InvisibleSpace]7\
\[InvisibleSpace]"  k1="\[InvisibleSpace]\(-4\)\[InvisibleSpace]"  k2="\
\[InvisibleSpace]1\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 4, " alpha= ", 45, " beta=", 7, "  k1=", -4, "  k2=", 1, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("For u=[m,a,a,...] and m=1...a, AND a="\
\[InvisibleSpace]5\),
      SequenceForm[ "For u=[m,a,a,...] and m=1...a, AND a=", 5],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]11\[InvisibleSpace]" beta="\[InvisibleSpace]3\
\[InvisibleSpace]"  k1="\[InvisibleSpace]7\[InvisibleSpace]"  k2="\
\[InvisibleSpace]5\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 11, " beta=", 3, "  k1=", 7, "  k2=", 5, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]2\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]18\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]7\[InvisibleSpace]"  k2="\
\[InvisibleSpace]7\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 2, " alpha= ", 18, " beta=", 4, "  k1=", 7, "  k2=", 7, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]3\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]27\[InvisibleSpace]" beta="\[InvisibleSpace]5\
\[InvisibleSpace]"  k1="\[InvisibleSpace]5\[InvisibleSpace]"  k2="\
\[InvisibleSpace]7\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 3, " alpha= ", 27, " beta=", 5, "  k1=", 5, "  k2=", 7, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]4\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]39\[InvisibleSpace]" beta="\[InvisibleSpace]6\
\[InvisibleSpace]"  k1="\[InvisibleSpace]1\[InvisibleSpace]"  k2="\
\[InvisibleSpace]5\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 4, " alpha= ", 39, " beta=", 6, "  k1=", 1, "  k2=", 5, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]5\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]59\[InvisibleSpace]" beta="\[InvisibleSpace]8\
\[InvisibleSpace]"  k1="\[InvisibleSpace]\(-5\)\[InvisibleSpace]"  k2="\
\[InvisibleSpace]1\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-1\)\),
      SequenceForm[ 
      "m=", 5, " alpha= ", 59, " beta=", 8, "  k1=", -5, "  k2=", 1, 
        "  k3=", -1],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("Now use a="\[InvisibleSpace]2\[InvisibleSpace]" and \
b="\[InvisibleSpace]4\),
      SequenceForm[ "Now use a=", 2, " and b=", 4],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    \("For u=[m,a,b,a,b,...] and m=1...b"\)], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]15\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]12\[InvisibleSpace]"  k2="\
\[InvisibleSpace]10\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-2\)\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 15, " beta=", 4, "  k1=", 12, "  k2=", 10, 
        "  k3=", -2],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]2\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]24\[InvisibleSpace]" beta="\[InvisibleSpace]5\
\[InvisibleSpace]"  k1="\[InvisibleSpace]10\[InvisibleSpace]"  k2="\
\[InvisibleSpace]12\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-2\)\),
      SequenceForm[ 
      "m=", 2, " alpha= ", 24, " beta=", 5, "  k1=", 10, "  k2=", 12, 
        "  k3=", -2],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]3\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]34\[InvisibleSpace]" beta="\[InvisibleSpace]6\
\[InvisibleSpace]"  k1="\[InvisibleSpace]4\[InvisibleSpace]"  k2="\
\[InvisibleSpace]10\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-2\)\),
      SequenceForm[ 
      "m=", 3, " alpha= ", 34, " beta=", 6, "  k1=", 4, "  k2=", 10, 
        "  k3=", -2],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]4\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]47\[InvisibleSpace]" beta="\[InvisibleSpace]7\
\[InvisibleSpace]"  k1="\[InvisibleSpace]\(-6\)\[InvisibleSpace]"  k2="\
\[InvisibleSpace]4\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-2\)\),
      SequenceForm[ 
      "m=", 4, " alpha= ", 47, " beta=", 7, "  k1=", -6, "  k2=", 4, 
        "  k3=", -2],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    \("For u=[m,b,a,b,a,...] and m=1...a"\)], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]1\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]11\[InvisibleSpace]" beta="\[InvisibleSpace]3\
\[InvisibleSpace]"  k1="\[InvisibleSpace]2\[InvisibleSpace]"  k2="\
\[InvisibleSpace]6\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-4\)\),
      SequenceForm[ 
      "m=", 1, " alpha= ", 11, " beta=", 3, "  k1=", 2, "  k2=", 6, 
        "  k3=", -4],
      Editable->False]], "Print",
  CellTags->"param"],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]2\[InvisibleSpace]" alpha= "\
\[InvisibleSpace]18\[InvisibleSpace]" beta="\[InvisibleSpace]4\
\[InvisibleSpace]"  k1="\[InvisibleSpace]\(-10\)\[InvisibleSpace]"  k2="\
\[InvisibleSpace]2\[InvisibleSpace]"  k3="\[InvisibleSpace]\(-4\)\),
      SequenceForm[ 
      "m=", 2, " alpha= ", 18, " beta=", 4, "  k1=", -10, "  k2=", 2, 
        "  k3=", -4],
      Editable->False]], "Print",
  CellTags->"param"]
}, Open  ]],

Cell[BoxData[""], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 933}, {0, 643}},
WindowSize->{917, 605},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "param"->{
    Cell[1776, 53, 7032, 127, 2230, "Input",
      CellTags->"param"],
    Cell[8811, 182, 220, 5, 25, "Print",
      CellTags->"param"],
    Cell[9034, 189, 462, 9, 25, "Print",
      CellTags->"param"],
    Cell[9499, 200, 220, 5, 25, "Print",
      CellTags->"param"],
    Cell[9722, 207, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[10181, 218, 462, 9, 25, "Print",
      CellTags->"param"],
    Cell[10646, 229, 220, 5, 25, "Print",
      CellTags->"param"],
    Cell[10869, 236, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[11328, 247, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[11787, 258, 462, 9, 25, "Print",
      CellTags->"param"],
    Cell[12252, 269, 220, 5, 25, "Print",
      CellTags->"param"],
    Cell[12475, 276, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[12934, 287, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[13393, 298, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[13852, 309, 462, 9, 25, "Print",
      CellTags->"param"],
    Cell[14317, 320, 220, 5, 25, "Print",
      CellTags->"param"],
    Cell[14540, 327, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[14999, 338, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[15458, 349, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[15917, 360, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[16376, 371, 462, 9, 25, "Print",
      CellTags->"param"],
    Cell[16841, 382, 224, 5, 25, "Print",
      CellTags->"param"],
    Cell[17068, 389, 89, 2, 25, "Print",
      CellTags->"param"],
    Cell[17160, 393, 460, 9, 25, "Print",
      CellTags->"param"],
    Cell[17623, 404, 460, 9, 25, "Print",
      CellTags->"param"],
    Cell[18086, 415, 458, 9, 25, "Print",
      CellTags->"param"],
    Cell[18547, 426, 462, 9, 25, "Print",
      CellTags->"param"],
    Cell[19012, 437, 89, 2, 25, "Print",
      CellTags->"param"],
    Cell[19104, 441, 456, 9, 25, "Print",
      CellTags->"param"],
    Cell[19563, 452, 464, 9, 25, "Print",
      CellTags->"param"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"param", 20722, 483}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 7032, 127, 2230, "Input",
  CellTags->"param"],
Cell[8811, 182, 220, 5, 25, "Print",
  CellTags->"param"],
Cell[9034, 189, 462, 9, 25, "Print",
  CellTags->"param"],
Cell[9499, 200, 220, 5, 25, "Print",
  CellTags->"param"],
Cell[9722, 207, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[10181, 218, 462, 9, 25, "Print",
  CellTags->"param"],
Cell[10646, 229, 220, 5, 25, "Print",
  CellTags->"param"],
Cell[10869, 236, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[11328, 247, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[11787, 258, 462, 9, 25, "Print",
  CellTags->"param"],
Cell[12252, 269, 220, 5, 25, "Print",
  CellTags->"param"],
Cell[12475, 276, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[12934, 287, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[13393, 298, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[13852, 309, 462, 9, 25, "Print",
  CellTags->"param"],
Cell[14317, 320, 220, 5, 25, "Print",
  CellTags->"param"],
Cell[14540, 327, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[14999, 338, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[15458, 349, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[15917, 360, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[16376, 371, 462, 9, 25, "Print",
  CellTags->"param"],
Cell[16841, 382, 224, 5, 25, "Print",
  CellTags->"param"],
Cell[17068, 389, 89, 2, 25, "Print",
  CellTags->"param"],
Cell[17160, 393, 460, 9, 25, "Print",
  CellTags->"param"],
Cell[17623, 404, 460, 9, 25, "Print",
  CellTags->"param"],
Cell[18086, 415, 458, 9, 25, "Print",
  CellTags->"param"],
Cell[18547, 426, 462, 9, 25, "Print",
  CellTags->"param"],
Cell[19012, 437, 89, 2, 25, "Print",
  CellTags->"param"],
Cell[19104, 441, 456, 9, 25, "Print",
  CellTags->"param"],
Cell[19563, 452, 464, 9, 25, "Print",
  CellTags->"param"]
}, Open  ]],
Cell[20042, 464, 26, 0, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

